/*
Questa query estrae tutti i seriali coinvolti in ordini web (che non sono dunque pi disponibili per Simula e FFW) ma che non trovano riscontro in ordini di produzione.
Faccio presente che nella linea AUTRYFFW61 l'ordine di produzione  il punto di arrivo comune ai seriali lavorati con Simula o con FFW.
La colonna ESISTE_ORD_PROD indica se l'ordine di produzione esiste (se l'ordine esiste, il record viene esposto perch il seriale non compare tra le sue righe)
La colonna TOT_RIGHE_ORD_PROD indica quante righe compongono l'ordine di produzione (ovviamente solo se esiste, altrimenti il conteggio risulta a 0)
La colonna TOT_RIGHE_ORD_WEB indica quante righe compongono l'ordine web
*/

SELECT  
  A.DATAORAORDINE,
  A.IDSESSIONE,
  A.NUMEROORDINE,
  A.STATUS,
  A.NOTEORDINE,
  A.RIFIDORDCONFERMA, 
  A.CODICEBARCODE,
  IIF(
    C.ID IS NULL,
    'NO',
    'SI'
  ) AS ESISTE_ORD_PROD,  
  (
    SELECT
      COUNT(*)
      
    FROM
      RIGHEORDC A4    
    
    WHERE
      A4.CODICEDOCUMENTO=A.RIFIDORDCONFERMA
      AND
      A4.SERIALE IS NOT NULL      
  ) AS TOT_RIGHE_ORD_PROD,
  (
    SELECT
      COUNT(*)
    
    FROM
      P_STOINSCAR A3
    
    WHERE
      A3.IDSESSIONE=A.IDSESSIONE
      AND
      A3.STATUS=1
      AND
      A3.CODICEBARCODE IS NOT NULL
  ) AS TOT_RIGHE_ORD_WEB

FROM
  (
    --Elenco seriali considerati impegnati con il web
    SELECT
      A1.CODICEBARCODE,
      A1.IDSESSIONE,
      B1.NUMEROORDINE,
      B1.STATUS,
      B1.DATAORAORDINE,      
      B1.NOTEORDINE,
      B1.RIFIDORDCONFERMA

    FROM
      P_STOINSCAR A1

      LEFT JOIN P_ORDINI B1 ON
      A1.IDSESSIONE=B1.IDSESSIONE
      AND
      B1.MAGAZZINO=61

    WHERE  
      A1.STATUS=1
      AND
      (
        B1.STATUS='CONFERMA AGE'
        OR
        B1.STATUS='AUTORIZZATO'
        OR
        (
          B1.STATUS='PARCHEGGIATO'
          AND
          DATEDIFF(HOUR FROM CAST(B1.DATAORAORDINE AS DATE) TO CURRENT_DATE)<=3
        )
      )
  ) A  
  
  LEFT JOIN(
    --Elenco seriali coinvolti in ordini produzione
    SELECT
      C2.SERIALE,
      COUNT(*) AS RICORRENZE
      
    FROM
      ORDC A2
      
      INNER JOIN LINEE B2 ON
      B2.NOME=A2.LINEA
      AND
      COALESCE(B2.TIPOORDINE,0)=0
      
      INNER JOIN RIGHEORDC C2 ON
      C2.CODICEDOCUMENTO=A2.ID
      AND
      C2.SERIALE IS NOT NULL
    
    GROUP BY
      C2.SERIALE
  ) B ON
  B.SERIALE=A.CODICEBARCODE 
  
  LEFT JOIN ORDC C ON
  C.ID=A.RIFIDORDCONFERMA

WHERE
  COALESCE(B.RICORRENZE,0)=0

ORDER BY  
  A.DATAORAORDINE,  
  A.CODICEBARCODE
  